# AWMF S2e Guideline Registry Record - Dissolve-E: AWMF Guideline Registry v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AWMF S2e Guideline Registry Record**

## Resource Profile: AWMF S2e Guideline Registry Record 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.awmf.org/awmf.ig/StructureDefinition/awmf-guideline-record-s2e | *Version*:0.2.0 |
| Draft as of 2026-01-29 | *Computable Name*:AWMFGuidelineRecordS2e |

 
AWMF S2e guideline based on systematic literature search and evaluation. 

### Guidance

This profile represents an **AWMF S2e Guideline Registry Record** based on systematic literature search and evaluation. S2e guidelines are "Evidence-based Guidelines" that rely on a formal evidence review process.

#### Overview

S2e guidelines are characterized by:

* Systematic literature search and evaluation
* Evidence-based methodology
* Formal assessment of available scientific evidence

This profile inherits from `AWMFGuidelineRegistryRecord` and pre-sets the guideline classification to S2e.

#### Key Element: Guideline Classification

The `category[awmfGuidelineClass]` is fixed to the S2e classification:

```
* category[awmfGuidelineClass] = cs-awmf-guideline-class#S2e "Evidence-based Guideline"

```

#### Example Usage

```
Instance: MyS2eGuideline
InstanceOf: awmf-guideline-record-s2e
Usage: #example
* version = "2.0"
* status = #final
* date = "2025-03-06"
* title = "S2e Guideline for [Topic]"
* identifier[awmf-register-number]
  * use = #official
  * value = "XXX-XXX"
* author[+] = Reference(MyAuthorRole)
* author[=].extension[ext-guideline-author-role].valueCodeableConcept = cs-guideline-author-role#registrant

```

For detailed information on all available elements, please refer to the parent profile [Guideline Registry Record](StructureDefinition-guideline-registry-record.md).

This profile of a FHIR Composition is derived from the [guideline-registry-record](http://fhir.awmf.org/awmf.ig/StructureDefinition/guideline-registry-record) FHIR resource.

**Usages:**

* Examples for this Profile: [Composition/AWMFGuidelineS2eExample](Composition-AWMFGuidelineS2eExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/awmf.ig|current/StructureDefinition/awmf-guideline-record-s2e)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-awmf-guideline-record-s2e.csv), [Excel](StructureDefinition-awmf-guideline-record-s2e.xlsx), [Schematron](StructureDefinition-awmf-guideline-record-s2e.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "awmf-guideline-record-s2e",
  "url" : "http://fhir.awmf.org/awmf.ig/StructureDefinition/awmf-guideline-record-s2e",
  "version" : "0.2.0",
  "name" : "AWMFGuidelineRecordS2e",
  "title" : "AWMF S2e Guideline Registry Record",
  "status" : "draft",
  "date" : "2026-01-29T18:27:10+00:00",
  "publisher" : "AWMF e.V.",
  "contact" : [
    {
      "name" : "AWMF e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.awmf.org"
        }
      ]
    }
  ],
  "description" : "AWMF S2e guideline based on systematic literature search and evaluation.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://fhir.awmf.org/awmf.ig/StructureDefinition/guideline-registry-record",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition"
      },
      {
        "id" : "Composition.category:awmfGuidelineClass",
        "path" : "Composition.category",
        "sliceName" : "awmfGuidelineClass",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://fhir.awmf.org/awmf.ig/CodeSystem/cs-awmf-guideline-class",
              "code" : "S2e",
              "display" : "Evidence-based Guideline"
            }
          ]
        }
      }
    ]
  }
}

```
