# Value Sets - Dissolve-E: AWMF Guideline Registry v0.2.0

* [**Table of Contents**](toc.md)
* **Value Sets**

## Value Sets

### Value Sets related to Guidelines

[AWMF Guideline Class](ValueSet-vs-awmf-guideline-class.md)

ValueSet listing values representing guideline classes according to the AWMF.

[AWMF Guideline Status](ValueSet-vs-awmf-guideline-status.md)

ValueSet listing values to define the guideline status according to the AWMF.

[Body System Conditions](ValueSet-vs-body-system-conditions.md)

ValueSet listing various body system conditions

[Care Level](ValueSet-vs-care-level.md)

ValueSet listing levels of care.

[Care Stage](ValueSet-vs-care-stage.md)

ValueSet listing stages of care from prevention to rehabilitation.

[Clinical Application Type](ValueSet-vs-clinical-application-type.md)

ValueSet listing different clinical application types

[Content Types](ValueSet-vs-content-types.md)

ValueSet listing types of content that can be part of a guideline or recommendation.

[Dissemination Website](ValueSet-vs-dissemination-website.md)

ValueSet listing types of dissemination websites

[Encounter Type](ValueSet-vs-encounter-type.md)

ValueSet listing types of patient encounters based on hospitalization status.

[Guideline Author Role](ValueSet-vs-guideline-author-role.md)

ValueSet listing roles that a author can have in a guideline.

[Guideline Contact Point VS](ValueSet-vs-guideline-contact-point.md)

ValueSet listing contact points relevant to guidelines, such as registrants, coordinators, and main contacts.

[Guideline Release Type](ValueSet-vs-guideline-release-type.md)

ValueSet listing different guideline release types

[Guideline Sections](ValueSet-vs-guideline-sections.md)

ValueSet listing values to use to define guideline sections

[Medical Subject Categories](ValueSet-vs-medical-subject-categories.md)

ValueSet listing values to classify medical subjects into different categories.

[Recommendation Tags](ValueSet-vs-recommendation-tags.md)

ValueSet listing different tags to use for recommendations

[Remark Type](ValueSet-vs-remark-type.md)

ValueSet listing types of remarks that can be associated with guidelines, including restrictions, warnings, and additional notes.

[Target Patient Group](ValueSet-vs-target-patient-group.md)

ValueSet listing patient population categories for guidelines, such as adults and children/adolescents.

#### Value Sets related to Recommendations

[Intended Audience Value Set](ValueSet-vs-intended-audience.md)

ValueSet listing codes representing intended audiences for a section

[Level Of Consensus](ValueSet-vs-level-of-consensus.md)

ValueSet listing values to define the level of consensus for a recommendation.

[Recommendation Direction](ValueSet-vs-recommendation-direction.md)

ValueSet defining the direction of a clinical recommendation.

[Recommendation Review Status Value Set](ValueSet-vs-recommendation-review-status.md)

ValueSet representing the review-related status of a recommendation in a new guideline version

[Recommendation Strength (AWMF) ValueSet](ValueSet-vs-recommendation-strength-awmf.md)

ValueSet of strength of recommendations as defined in AWMF guideline methodology.

[Recommendation Synthesis Type](ValueSet-vs-recommendation-synthesis-type.md)

ValueSet listing different synthesis Types of recommendations

[Recommendation Tags](ValueSet-vs-recommendation-tags.md)

ValueSet listing different tags to use for recommendations

#### Value Sets related to Ratings

[AGREE II Domains Value Set](ValueSet-vs-agree-ii-domains.md)

ValueSet encompassing all domains from the AGREE II instrument.

[AMSTAR 2 Confidence Ratings Value Set](ValueSet-vs-amstar2-confidence-ratings.md)

ValueSet encompassing all overall confidence ratings from the AMSTAR 2 critical appraisal tool.

[OCEBM 2009 Levels of Evidence Value Set](ValueSet-vs-ocebm-2009-levels-of-evidence.md)

ValueSet encompassing all levels from the Oxford Centre for Evidence-Based Medicine 2009 Levels of Evidence.

[OCEBM 2011 Levels of Evidence Value Set](ValueSet-ocebm-2011-levels-of-evidence-vs.md)

ValueSet encompassing all levels from the OCEBM 2011 Levels of Evidence.

[PICO related terms](ValueSet-vs-pico.md)

ValueSet listing different terms related to PICO question and objects

[ROBIS Judgment of Risk of Bias Value Set](ValueSet-vs-robis-judgment-of-risk-of-bias.md)

ValueSet encompassing all risk of bias judgment values from the ROBIS tool.

[ROBIS Risk of Bias Domains Value Set](ValueSet-vs-robis-risk-of-bias-domains.md)

ValueSet encompassing all risk of bias domains from the ROBIS tool.

[RoB2 Overall Judgment ValueSet](ValueSet-vs-rob-2-overall-judgment.md)

ValueSet listing values to represent the overall judgment of risk of bias assessed by the RoB2 tool for evaluating risk of bias for randomized trials.

[SIGN Grade of Recommendation Value Set](ValueSet-vs-sign-grade-of-recommendation.md)

ValueSet encompassing all grades of recommendation from the SIGN (Scottish Intercollegiate Guidelines Network) Grades of Recommendation.

[SIGN Level of Evidence Value Set](ValueSet-vs-sign-level-of-evidence.md)

ValueSet encompassing all levels from the SIGN (Scottish Intercollegiate Guidelines Network) Levels of Evidence.

##### Value Sets related to GRADE

[Rating Acceptability](ValueSet-vs-rating-acceptability.md)

ValueSet defining if the alternatives are acceptable for the target population and its implementors?

[Rating Benefits And Harms](ValueSet-vs-rating-benefits-and-harms.md)

ValueSet listing values to represent the summary of the most important benefits and harms

[Rating Certainty Of Evidence](ValueSet-vs-rating-certainty-of-evidence.md)

Codes from EvidenceCertaintyRating related to certainty of evidence

[Rating Concern Degree](ValueSet-vs-rating-concern-degree.md)

ValueSet listing codes from EvidenceCertaintyRating related to degree of concern

[Rating Equity](ValueSet-vs-rating-equity.md)

ValueSet listing values to represent how the different alternatives affect equity

[Rating Feasibility](ValueSet-vs-rating-feasibility.md)

ValueSet listing values to reprensent how feasible will it be to implement the different alternatives and if there are any issues

[Rating Preference And Values](ValueSet-vs-rating-preference-and-values.md)

ValueSet listing typical patient preferences and values as well as common issues or expected variability

[Rating Resources](ValueSet-vs-rating-resources.md)

ValueSet listing values to indicate if there are issues related to costs or resource use.

