# Code Systems - Dissolve-E: AWMF Guideline Registry v0.2.0

* [**Table of Contents**](toc.md)
* **Code Systems**

## Code Systems

### General Code Systems

[AWMF Guideline Class](CodeSystem-cs-awmf-guideline-class.md)

As part of the project planning for the creation or updating of a guideline, a decision should be made at an early stage about the planned level classification ("S classification") according to the AWMF's system of rules (1-3). The S-classification scheme of the AWMF differentiates between the classes S1 treatment recommendation as well as S2e, S2k and S3 guideline. The "S" stands for the extent of the applied systematic approach in the development process of a guideline. Each class thus stands for a specific methodological concept that must be presented in a way that is comprehensible to the users. The choice of class is based on the question of how much effort is appropriate and feasible. The need for legitimacy for the implementation of the guideline (convincing the target group) must be taken into account. When choosing a higher S-classification in the context of updating a guideline, the adaptation to the corresponding methodology has to be considered.

[AWMF Guideline Status](CodeSystem-cs-awmf-guideline-status.md)

CodeSystem representing the guideline status according to the AWMF.

[Body System Conditions](CodeSystem-cs-body-systems-conditions.md)

CodeSystem representing various body system conditions.

[Care Setting](CodeSystem-cs-care-setting.md)

CodeSystem defining different care settings, including levels of care, healthcare services, and treatment contexts.

[Clinical Application Type](CodeSystem-cs-clinical-application-type.md)

CodeSystem defining different clinical application types

[Contact Point](CodeSystem-cs-contact-point.md)

CodeSystem defining types of contact points for a guideline

[Guideline Author Role](CodeSystem-cs-guideline-author-role.md)

CodeSystem defining roles for the author of the guideline.

[Guideline Release Type](CodeSystem-cs-guideline-release-type.md)

CodeSystem defining different guideline release types

[Guideline Sections](CodeSystem-cs-guideline-sections.md)

Sections of a guideline, describing various aspects such as its intention, target patient group, care setting, and other relevant contextual information.

[Level of Consensus](CodeSystem-cs-level-of-consensus.md)

CodeSystem defining the values representing the level of consensus for a recommendation.

[Medical Subject Categories](CodeSystem-cs-medical-subject-categories.md)

CodeSystem defining values to classify medical subjects into different categories.

[Recommendation Synthesis Type](CodeSystem-cs-recommendation-synthesis-type.md)

CodeSystem defining values representing the synthesis type of a recommendation

[Recommendation Tags](CodeSystem-cs-recommendation-tags.md)

CodeSystem defining codes to represent tags for recommendations

[Related Artifact Types](CodeSystem-cs-related-artifact-types.md)

CodeSystem defining types of related artifacts that can be part of a guideline.

[Remark Type](CodeSystem-cs-remark-type.md)

CodeSystem defining different types of remarks that can be associated with guidelines, including restrictions, warnings, and additional notes.

[RoB2 Overall Judgment](CodeSystem-cs-rob-2-overall-judgment.md)

CodeSystem representing the overall judgment of risk of bias assessed by the RoB2 tool for evaluating risk of bias for randomized trials.

[Target Patient Group](CodeSystem-cs-target-patient-group.md)

CodeSystem defining the intended patient population for whom the guideline is applicable.

[awmf](CodeSystem-cs-awmf.md)

CodeSystem representing different codes of interest for the Arbeitsgemeinschaft der Wissenschaftlichen Medizinischen Fachgesellschaften (AWMF)

### Code Systems related to Ratings

[AGREE II Domains](CodeSystem-cs-agree-ii-domains.md)

CodeSystem representing the domains assessed by the AGREE II instrument for evaluating the quality of clinical practice guidelines.

[AMSTAR 2 Overall Confidence Ratings](CodeSystem-cs-amstar2-confidence-ratings.md)

CodeSystem representing the overall confidence ratings from the AMSTAR 2 critical appraisal tool.

**ERROR**: Could not find reference for “CS:Evidence Rating System Code System”

[OCEBM 2011 Levels of Evidence](CodeSystem-cs-ocebm-2011-levels-of-evidence.md)

CodeSystem representing the Oxford Centre for Evidence-Based Medicine 2011 Levels of Evidence.

[Recommendation Strength (AWMF)](CodeSystem-cs-recommendation-strength-awmf.md)

CodeSystem defining the grading of recommendations according to German guideline methodology as used in AWMF S3 guidelines.

[RoB2 Overall Judgment](CodeSystem-cs-rob-2-overall-judgment.md)

CodeSystem representing the overall judgment of risk of bias assessed by the RoB2 tool for evaluating risk of bias for randomized trials.

[ROBIS Judgment of Risk of Bias](CodeSystem-cs-robis-judgment-of-risk-of-bias.md)

CodeSystem representing the judgment of risk of bias assessed by the ROBIS tool for evaluating risk of bias in systematic reviews.

[ROBIS Risk of Bias Domains](CodeSystem-cs-robis-risk-of-bias-domains.md)

CodeSystem representing the domains assessed by the ROBIS tool for evaluating risk of bias in systematic reviews.

#### Code Systems related to Grades

[Evidence To Decision Certainty Rating](CodeSystem-cs-evidence-to-decision-certainty-rating.md)

CodeSystem defining GRADE Evidence to Decision (EtD) Framework Certainty Ratings

[Evidence To Decision Certainty type](CodeSystem-cs-evidence-to-decision-certainty-type.md)

CodeSystem defining values to represent the GRADE Evidence to Decision (EtD) Framework Certainty Type

### Code Systems related to Recommendations

[Intended Audience Code System](CodeSystem-cs-intended-audience.md)

CodeSystem defining possible intended audiences for a section

**ERROR**: Could not find reference for “CS:Recommendation Version Status Code System”

