# Examples - Dissolve-E: AWMF Guideline Registry v0.2.0

* [**Table of Contents**](toc.md)
* **Examples**

## Examples

### ArtifactAssessment

* [Certainty of Evidence Rating for Multiplex-PCR-Diagnostik - Antibiotic Days](ArtifactAssessment-EvA-MultiplexPCRDiagnostic-AntibioticDays.md)
* [Certainty of Evidence Rating for Multiplex-PCR-Diagnostik - Mortality](ArtifactAssessment-EvA-MultiplexPCRDiagnostic-Mortality.md)
* [Certainty of Evidence Rating for Multiplex-PCR-Diagnostik - Time to Deescalation](ArtifactAssessment-EvA-MultiplexPCRDiagnostic-TimeToDeescalation.md)
* [Certainty of Evidence Rating Ris of Bias for Cognitive Tests When Suspecting Dementia - Sensitivity](ArtifactAssessment-RoB-CognitiveTestsWhenSuspectingDementia-Sensitivity.md)
* [Certainty of Evidence Rating Ris of Bias for Cognitive Tests When Suspecting Dementia - Specificity](ArtifactAssessment-RoB-CognitiveTestsWhenSuspectingDementia-Specificity.md)
* [RecommendationCognitiveTestsWhenSuspectingDementia-Justification](ArtifactAssessment-RecommendationCognitiveTestsWhenSuspectingDementia-Justification.md)
* [RecommendationHAPDiagnosis-A-Justification](ArtifactAssessment-RecommendationHAPDiagnosis-A-Justification.md)
* [RecommendationHAPDiagnosis-B-Justification](ArtifactAssessment-RecommendationHAPDiagnosis-B-Justification.md)
* [RecommendationMultiplexPCRDiagnostic-Justification](ArtifactAssessment-RecommendationMultiplexPCRDiagnostic-Justification.md)

### Citation

* [Citation Systematic Review](Citation-CitationSystematicReviewTsoi2015.md)

### Composition

* [AWMF Guideline Record S3 Example](Composition-AWMFGuidelineRecordS3Example.md)
* [AWMF Guideline S1 Example](Composition-AWMFGuidelineS1Example.md)
* [AWMF Guideline S2e Example](Composition-AWMFGuidelineS2eExample.md)
* [AWMF Guideline S2k Example](Composition-AWMFGuidelineRecordS2kExample.md)
* [Guideline Example](Composition-GuidelineExample.md)
* [Guideline Registry Record Example](Composition-GuidelineRegistryRecordExample.md)
* [Guideline with contributing author referencing Practitioner (fails invariant)](Composition-RR-TestInvContribAuthorRefPerson-SHOULD-FAIL.md)
* [Guideline with leading author referencing Organization (passes invariant)](Composition-RR-TestInvLeadingAuthorRefOrganization-SHOULD-PASS.md)
* [Guideline with leading author referencing Practitioner (fails invariant)](Composition-RR-TestInvLeadingAuthorRefPerson-SHOULD-FAIL.md)
* [HAP Diagnose](Composition-RecommendationHAPDiagnosis.md)
* [HAP Diagnose - Empfehlung A](Composition-RecommendationHAPDiagnosis-A.md)
* [HAP Diagnose - Empfehlung B](Composition-RecommendationHAPDiagnosis-B.md)
* [Multiplex-PCR-Diagnostik](Composition-RecommendationMultiplexPCRDiagnostic.md)
* [Recommendation Example](Composition-RecommendationExample.md)
* [S3-Leitlinie Demenzen Living Guideline - Langfassung](Composition-Demenzen.md)
* [S3-Leitlinie Demenzen Living Guideline - Record](Composition-DemenzenRecord.md)
* [S3-Leitlinie Epidemiologie, Diagnostik und Therapie erwachsener Patienten mit nosokomialer Pneumonie](Composition-NosokomialePneumonieRecord.md)
* [S3-Leitlinie Epidemiologie, Diagnostik und Therapie erwachsener Patienten mit nosokomialer Pneumonie](Composition-NosokomialePneumonie.md)
* [Screening auf kognitive Beeinträchtigung](Composition-RecommendationCognitiveTestsWhenSuspectingDementia.md)
* [Test: Author Both Leading and Contributing (Should Fail)](Composition-RR-TestTestInvAuthorLeadVsContrExclusive-Both-SHOULD-FAIL.md)
* [Test: No Official Identifier (Should Fail)](Composition-G-TestTestInvRequireOfficialIdentifier-NoOfficialId-SHOULD-FAIL.md)
* [Test: No Official Identifier (Should Fail)](Composition-RR-TestTestInvRequireOfficialId-NoOfficialId-SHOULD-FAIL.md)
* [Test: No Registrant Author (Should Fail)](Composition-RR-TestTestInvAuthorRegistSingleton-NoRegistrant-SHOULD-FAIL.md)
* [Test: Preliminary With Consultation Period (Should Pass)](Composition-RR-TestTestInvPreliminaryCompNeedsConsultPeriod-SHOULD-PASS.md)
* [Test: Preliminary Without Consultation Period (Should Fail)](Composition-RR-TestTestInvPrelimCompNeedsConsultPeriod-NoDate-SHOULD-FAIL.md)
* [Test: Registered With Planned Completion Date (Should Pass)](Composition-RR-TestTestInvRegCompNeedsPlannedComplDate-SHOULD-PASS.md)
* [Test: Registered Without Planned Completion Date (Should Fail)](Composition-RR-TestTestInvRegCompNeedsPlannedComplDate-NoDate-SHOULD-FAIL.md)
* [Test: Release Type If Registered (Should Pass)](Composition-RR-TestTestInvRequireReleaseTypeIfRegistered-SHOULD-PASS.md)
* [Test: Release Type No Tag (Should Fail)](Composition-RR-TestTestInvRequireReleaseTypeIfRegistered-NoTag-SHOULD-FAIL.md)
* [Test: Release Type Wrong Code (Should Fail)](Composition-RR-TestTestInvRequireReleaseTypeIfReg-WrongCode-SHOULD-FAIL.md)
* [Test: Single Registrant Author (Should Pass)](Composition-RR-TestTestInvAuthorRegistrantSingleton-SHOULD-PASS.md)
* [Test: Two Official Identifiers (Should Fail)](Composition-G-TestTestInvRequireOfficialIdentifier-TwoOfficialId-SHOULD-FAIL.md)
* [Test: Two Official Identifiers (Should Fail)](Composition-RR-TestTestInvRequireOfficialId-TwoOfficialId-SHOULD-FAIL.md)
* [Test: Two Registrant Authors (Should Fail)](Composition-RR-TestTestInvAuthorRegistSingleton-TwoRegistrants-SHOULD-FAIL.md)
* [Test: Version as Text (Should Fail)](Composition-G-TestTestInvVersionMajorMinor-VersionInvalid2-SHOULD-FAIL.md)
* [Test: Version as Text (Should Fail)](Composition-RR-TestTestInvVersionMajorMinor-VersionInvalid2-SHOULD-FAIL.md)
* [Test: Version Major.Minor.Patch (Should Fail)](Composition-G-TestTestInvVersionMajorMinor-VersionPatch-SHOULD-FAIL.md)
* [Test: Version Major.Minor.Patch (Should Fail)](Composition-RR-TestTestInvVersionMajorMinor-VersionPatch-SHOULD-FAIL.md)
* [Test: Version with Prefix (Should Fail)](Composition-G-TestTestInvVersionMajorMinor-VersionInvalid-SHOULD-FAIL.md)
* [Test: Version with Prefix (Should Fail)](Composition-RR-TestTestInvVersionMajorMinor-VersionInvalid-SHOULD-FAIL.md)

### ConceptMap

* [Concept map from concepts from standardized vocabularies (that are not standard OMOP concepts) to Concept IDs of OMOP standard Concepts](ConceptMap-FHIRStatusToAWMFStatus.md)

### DocumentReference

* [Foliensatz](DocumentReference-Guideline-020-013-SlideDeck.md)
* [Guideline Attachment Example](DocumentReference-guideline-attachment-example.md)
* [Guideline Attachment Patient Version Example](DocumentReference-guideline-attachment-patient-version-example.md)
* [Implementierungshilfe](DocumentReference-Guideline-020-013-ImplementationGuidance.md)
* [Kurzfassung](DocumentReference-Guideline-020-013-ShortVersion.md)
* [Langfassung](DocumentReference-Guideline-020-013-LongVersion.md)
* [Leitlinienreport](DocumentReference-Guideline-020-013-GuidelineReport.md)
* [Patienteninformation](DocumentReference-Guideline-020-013-PatientVersion.md)

### Evidence

* [Evidence-Multiplex PCR Diagnostic-Antibiotic Days](Evidence-Evidence-MultiplexPCRDiagnostic-AntibioticDays.md)
* [Evidence-Multiplex PCR Diagnostic-Mortality](Evidence-Evidence-MultiplexPCRDiagnostic-Mortality.md)
* [Evidence-Multiplex PCR Diagnostic-Time to Deescalation](Evidence-Evidence-MultiplexPCRDiagnostic-TimeToDeescalation.md)

### EvidenceVariable

* [Outcome Antibiotic Days](EvidenceVariable-OutcomeAntibioticDays.md)
* [Outcome Mortality](EvidenceVariable-OutcomeMortality.md)
* [Outcome Time to Deescalation](EvidenceVariable-OutcomeTimeToDeescalation.md)

### Group

* [PICO Comparator of Recommendation 17 from Guideline 038-013](Group-PICOComparatorRec17.md)
* [PICO Intervention of Recommendation 17 from Guideline 038-013](Group-PICOInterventionRec17.md)
* [PICO Outcome Sensitivity of Recommendation 17 from Guideline 038-013](Group-PICOOutcomeSensitivityRec17.md)
* [PICO Outcome Specificity of Recommendation 17 from Guideline 038-013](Group-PICOOutcomeSpecificityRec17.md)
* [PICO Population of Recommendation 17 from Guideline 038-013](Group-PICOPopulationRec17.md)
* [PICO Question of Recommendation 17 from Guideline 038-013](Group-PICOQuestionRec17.md)

### Organization

* [Arbeitsgemeinschaft der Wissenschaftlichen Medizinischen Fachgesellschaften (AWMF)](Organization-AWMF.md)
* [AWMF Member Organization Example](Organization-AWMFMemberOrganizationExample.md)
* [DGAI](Organization-DGAI.md)
* [DGCH](Organization-DGCH.md)
* [DGHM](Organization-DGHM.md)
* [DGI](Organization-DGI.md)
* [DGIIN](Organization-DGIIN.md)
* [DGIM](Organization-DGIM.md)
* [DGP](Organization-DGP.md)
* [DGPPN](Organization-DGPPN.md)
* [DRG](Organization-DRG.md)
* [DSG](Organization-DSG.md)
* [GfV](Organization-GFV.md)
* [Medical Society Example](Organization-MedicalSocietyExample.md)
* [Netzwerk chronisch pulmonale Aspergillose (CPAnet)](Organization-CPAnet.md)
* [PEG](Organization-PEG.md)
* [Robert Koch-Institut](Organization-RKI.md)

### PlanDefinition

* [Recommendation-PlanDefinition-example](PlanDefinition-Recommendation-PlanDefinition-example.md)

### Practitioner

* [contributor0](Practitioner-contributor0.md)
* [contributor1](Practitioner-contributor1.md)
* [contributor2](Practitioner-contributor2.md)
* [contributor3](Practitioner-contributor3.md)
* [contributor4](Practitioner-contributor4.md)
* [Guideline Author Example](Practitioner-GuidelineAuthorExample.md)
* [Jessica Rademacher](Practitioner-JessicaRademacher.md)

### PractitionerRole

* [Guideline Author Role Example](PractitionerRole-GuidelineAuthorRoleExample.md)
* [Jessica Rademacher for DGP in the context of 020-013](PractitionerRole-JessicaRademacherDGPFor020-013.md)

-------

