# DISSOLVE-E Implementation Guide - Dissolve-E: AWMF Guideline Registry v0.2.0

* [**Table of Contents**](toc.md)
* **DISSOLVE-E Implementation Guide**

## DISSOLVE-E Implementation Guide

| | |
| :--- | :--- |
| *Official URL*:http://fhir.awmf.org/awmf.ig/ImplementationGuide/awmf.ig | *Version*:0.2.0 |
| Draft as of 2026-01-29 | *Computable Name*:AWMFGuidelineRegistryIG |

# Dissolve-E - Digitization of the AWMF guideline registry for an open, guideline-based, trustworthy evidence ecosystem

### Background

Dissolve-E (**Digitization of the AWMF guideline registry for an open, guideline-based, trustworthy evidence ecosystem**) aims to digitize the guidelines registry maintained by the Association of the Scientific Medical Societies in Germany (AWMF). This registry plays a crucial role in ensuring quality medical care by providing evidence-based clinical guidelines. However, this registry is currently analog without comprehensive digital version existing yet.

**Potential Objectives and Benefits are:**

* Developing a digital infrastructure that meets national and international technical standards and requirements;
* Ideally facilitating the creation, updating, and access of clinical guidelines;
* Providing tailored formats and decision-support tools for medical professionals;
* Potentially enabling efficient real-time comparison between guideline recommendations, treatment options, and latest scientific findings.

### Summary

We hereby present the Implementation Guide (IG) developed for DISSOLVE-E based combining the [evidence-based medicine on FHIR (EBMonFHIR)][EMBonFHIR] IG and further defined artifacts to represent evidence-based clinical practice guidelines and recommendations, including the evidence that led to the single recommendations. Additional FHIR artifacts allow to describe the certainty of evidence based on different rating systems or the strength of recommendation, as well as the organizations and persons involved in the guideline process.

This IG is based on FHIR R6 (6.0.0-ballot3).

#### Profiles to represent a clinical practice guideline

While DISSOLVE-E is initiated by the AWMF and foremost aiming to develop a digital guidelines registry for Germany, we propose a general guideline profile as well as registry-specific profiles including AWMF specific requirements.

| | | |
| :--- | :--- | :--- |
| [Guideline](StructureDefinition-awmf-guideline.md) | [Composition](http://build.fhir.org/composition.html) | Representation of a general clinical practice guideline. |
| [Guideline Attachment](StructureDefinition-guideline-attachment.md) | [DocumentReference](http://build.fhir.org/documentreference.html) | Representation of an attachment to a clinical practice guideline. |
| [Guideline Registry Record](StructureDefinition-guideline-registry-record.md) | [Composition](http://build.fhir.org/composition.html) | Representation of a guideline registry record containing metadata and registry-specific information. |
| [AWMF S1 Guideline Registry Record](StructureDefinition-awmf-guideline-record-s1.md) | [Composition](http://build.fhir.org/composition.html) | Representation of an AWMF S1 guideline registry record encompassing expert recommendations developed through informal consensus. |
| [AWMF S2e Guideline Registry Record](StructureDefinition-awmf-guideline-record-s2e.md) | [Composition](http://build.fhir.org/composition.html) | Representation of an AWMF S2e guideline registry record based on systematic literature search and evaluation. |
| [AWMF S2k Guideline Registry Record](StructureDefinition-awmf-guideline-record-s2k.md) | [Composition](http://build.fhir.org/composition.html) | Representation of an AWMF S2k guideline registry record based on structured consensus by a representative panel. |
| [AWMF S3 Guideline Registry Record](StructureDefinition-awmf-guideline-record-s3.md) | [Composition](http://build.fhir.org/composition.html) | Representation of an AWMF S3 guideline registry record based on systematic evidence review and structured consensus by a representative panel. |

#### Profile to represent a recommendation

| | | |
| :--- | :--- | :--- |
| [Recommendation](StructureDefinition-recommendation.md) | [Composition](http://build.fhir.org/composition.html) | Representation of a clinical practice guideline recommendation. |

##### Profiles to represent the evidence assessment upon which a clinical practice guideline recommendation is based

We propose a general profile as well as profiles based on different quality and risk of bias assessment systems.

| | | |
| :--- | :--- | :--- |
| [Evidence Overall Quality Assessment](StructureDefinition-evidence-overall-quality-assessment.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | General representation of a certainty of evidence rating, possibly outcome-specific. |
| [Evidence Internal Validity Assessment](StructureDefinition-evidence-internal-validity-assessment.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Assessment of the internal validity of evidence. |
| [Evidence Internal Assessment AGREE II](StructureDefinition-evidence-internal-assessment-agreeii.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Assessment of guideline quality using the AGREE II instrument. |
| [Evidence Internal Assessment AMSTAR 2](StructureDefinition-evidence-internal-assessment-amstar2.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Assessment of systematic review quality using AMSTAR 2. |
| [Evidence Internal Assessment Cochrane Risk of Bias](StructureDefinition-evidence-internal-assessment-cochrane-rob.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Assessment of risk of bias using Cochrane RoB tool. |
| [Evidence Internal Assessment ROBIS](StructureDefinition-evidence-internal-assessment-robis.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Assessment of risk of bias using ROBIS (Risk of Bias in Systematic Reviews). |
| [Evidence Overall Quality Assessment](StructureDefinition-evidence-overall-quality-assessment.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Overall assessment of evidence quality. |
| [Evidence Overall Assessment GRADE](StructureDefinition-evidence-overall-assessment-grade.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Overall assessment of evidence certainty using GRADE. |
| [Evidence Overall Assessment Oxford 2011](StructureDefinition-evidence-overall-assessment-oxford2011.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Overall assessment of evidence certainty using Oxford 2011 levels of evidence. |

##### Profiles to represent the recommendation justification

We propose a general profile as well as specific profiles based on various internationally recognized rating systems used to describe the strength of recommendation:

| | | |
| :--- | :--- | :--- |
| [Recommendation Justification](StructureDefinition-recommendation-justification.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | General representation of a structured assessment of the evidence and consensus that underpins a recommendation. |
| [Recommendation Justification AWMF](StructureDefinition-recommendation-justification-awmf.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Recommendation justification including AWMF strength of recommendation rating. |
| [Recommendation Justification Expert Consensus](StructureDefinition-recommendation-justification-expert-consensus.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Recommendation justification based on expert consensus. |
| [Recommendation Justification GRADE](StructureDefinition-recommendation-justification-grade.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Recommendation justification including GRADE strength of recommendation rating. |
| [Recommendation Justification OXFORD 2009](StructureDefinition-recommendation-justification-oxford-2009.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Recommendation justification including Oxford 2009 grade of recommendation. |
| [Recommendation Justification OXFORD 2011](StructureDefinition-recommendation-justification-oxford-2011.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Recommendation justification including Oxford 2011 grade of recommendation. |
| [Recommendation Justification SIGN](StructureDefinition-recommendation-justification-sign.md) | [ArtifactAssessment](http://build.fhir.org/artifactassessment.html) | Recommendation justification including SIGN grade of recommendation. |

#### Profiles for PICO Questions

To support structured representation of clinical questions, we provide profiles for PICO (Population, Intervention, Comparator, Outcome) questions:

| | | |
| :--- | :--- | :--- |
| [PICO Question](StructureDefinition-pico-question.md) | [Group](http://build.fhir.org/group.html) | Structured definition of a PICO question in the context of guidelines and recommendations. |
| [Conceptual Cohort Definition Population](StructureDefinition-conceptual-cohort-definition-population.md) | [Group](http://build.fhir.org/group.html) | Definition of the population in a PICO question. |
| [Conceptual Cohort Definition Intervention](StructureDefinition-conceptual-cohort-definition-intervention.md) | [Group](http://build.fhir.org/group.html) | Definition of the intervention in a PICO question. |
| [Conceptual Cohort Definition Comparator](StructureDefinition-conceptual-cohort-definition-comparator.md) | [Group](http://build.fhir.org/group.html) | Definition of the comparator in a PICO question. |
| [Conceptual Cohort Definition Outcome](StructureDefinition-conceptual-cohort-definition-outcome.md) | [Group](http://build.fhir.org/group.html) | Definition of the outcome in a PICO question. |

#### Profiles for involved Organizations and Persons

| | | |
| :--- | :--- | :--- |
| [AWMF Member Organization](StructureDefinition-awmf-member-organization.md) | [Organization](http://build.fhir.org/organization.html) | Representation of an organization that is a member of the AWMF. |
| [Medical Society](StructureDefinition-medical-society.md) | [Organization](http://build.fhir.org/organization.html) | Representation of a medical society involved in guideline development. |
| [Patient Organization](StructureDefinition-patient-organization.md) | [Organization](http://build.fhir.org/organization.html) | Representation of a patient organization involved in guideline development. |
| [Guideline Author](StructureDefinition-guideline-author.md) | [Practitioner](http://build.fhir.org/practitioner.html) | Representation of a person that authored a guideline. |
| [Guideline Author Role](StructureDefinition-ext-guideline-author-role.md) | [PractitionerRole](http://build.fhir.org/practitionerrole.html) | Representation of the role of the author of the guideline. |

#### Other Profiles

| | | |
| :--- | :--- | :--- |
| [Outcome Evidence](StructureDefinition-outcome-evidence.md) | [Evidence](http://build.fhir.org/evidence.html) | Representation of evidence for a specific outcome. |
| [Citation List](StructureDefinition-citation-list.md) | [Citation](http://build.fhir.org/citation.html) | Representation of a list of citations supporting recommendations or evidence. |

### Graphical Overview of the FHIR Resources

The following diagramm provides an overview of the diverse profiles used in this the DISSOLVE-E-IG and their relationship allowing for a structured representation of clinical practice guidelines with accompanying evidence and evidence-to-decision information. The cardinalities shown represent the respective maxima. Please consult the pages of the respective [profiles](profiles.md) for additional details.

![](awmf-ig-0.2.0-class-diagram.png)

### Authors (in alphabetical order) with Affiliations

* [Sophie Klopfenstein](https://github.com/klsophie) (Berlin Institute of Health at Charité)
* [Gregor Lichtner](https://github.com/glichtner) (University Medicine Greifswald)
* Ina Müller (Association of the Scientific Medical Societies in Germany)
* [Johannes Starlinger](https://github.com/starlinger) (Howto Health GmbH)

### Contributing Organisations (in alphabetical order)

* Association of the Scientific Medical Societies in Germany (AWMF)
* aQua – Institute for Applied Quality Improvement and Research in Health Care
* Charité–Universitätsmedizin Berlin / Berlin Institute of Health
* Clinical Guideline Services GmbH
* Computable Publishing LLC, Scientific Knowledge Accelerator Foundation
* Evidence Prime Inc.
* German Cancer Society, Office Leitlinienprogramm Onkologie
* German Society for Wound Healing and Wound Treatment e.V.
* German Society of Internal Medicine
* HL7 Germany
* Howto Health GmbH
* Institute for Evidence in Medicine, University of Freiburg
* MAGIC Evidence Ecosystem Foundation
* University Medicine Greifswalds

### Further information

#### Ethical Considerations

**The Ethics Committee of the Berlin chamber of physicians in accordance with its code of conduct §15 section 1 (Eth-KB-24-11) confirmed that no ethical approval is needed for this study.**

#### Funding Information

This project is publicly funded by the Innovation Committee of the Federal Joint Committee (German: Gemeinsamer Bundesausschuss, short: G-BA) for three years (April 2024 to March 2027) with a total of around 2.8 million euros under the grant number: 01VSF23021.

#### Links

* DISSOLVE-E on the Website of the Federal Joint Committee (G-BA) in [German](https://innovationsfonds.g-ba.de/projekte/versorgungsforschung/dissolve-e.597) or [English](https://www.awmf.org/die-awmf/imwi/projekte/dissolve-e-english-version)
* [GitHub project](https://github.com/Dissolve-E/awmf-ig)
* Profile definitions in the DISSOLVE-E Implementation Guide can be downloaded as a package via [https://fhir.awmf.org/awmf.ig/package.tgz](https://fhir.awmf.org/awmf.ig/package.tgz).

