# awmf.ig#0.2.0: Dissolve-E: AWMF Guideline Registry

## Pages

* [DISSOLVE-E Implementation Guide](index.md)
* [Profiles](profiles.md)
* [Value Sets](valuesets.md)
* [Extensions](extensions.md)
* [Artifacts Summary](artifacts.md)
* [Code Systems](codesystems.md)
* [Examples](examples.md)
* [Downloads](downloads.md)

## Resources

### CodeSystems

* [AGREE II Domains](CodeSystem-cs-agree-ii-domains.md)
* [AMSTAR 2 Overall Confidence Ratings](CodeSystem-cs-amstar2-confidence-ratings.md)
* [AWMF Guideline Class](CodeSystem-cs-awmf-guideline-class.md)
* [AWMF Guideline Status](CodeSystem-cs-awmf-guideline-status.md)
* [awmf](CodeSystem-cs-awmf.md)
* [Body System Conditions](CodeSystem-cs-body-systems-conditions.md)
* [Care Setting](CodeSystem-cs-care-setting.md)
* [Clinical Application Type](CodeSystem-cs-clinical-application-type.md)
* [Contact Point](CodeSystem-cs-contact-point.md)
* [Evidence To Decision Certainty Rating](CodeSystem-cs-evidence-to-decision-certainty-rating.md)
* [Evidence To Decision Certainty type](CodeSystem-cs-evidence-to-decision-certainty-type.md)
* [Guideline Author Role](CodeSystem-cs-guideline-author-role.md)
* [Guideline Release Type](CodeSystem-cs-guideline-release-type.md)
* [Guideline Sections](CodeSystem-cs-guideline-sections.md)
* [Intended Audience Code System](CodeSystem-cs-intended-audience.md)
* [Level of Consensus](CodeSystem-cs-level-of-consensus.md)
* [Medical Subject Categories](CodeSystem-cs-medical-subject-categories.md)
* [OCEBM 2009 Levels of Evidence](CodeSystem-cs-ocebm-2009-levels-of-evidence.md)
* [OCEBM 2011 Levels of Evidence](CodeSystem-cs-ocebm-2011-levels-of-evidence.md)
* [PICO Related Terms](CodeSystem-cs-pico.md)
* [Recommendation Direction](CodeSystem-cs-recommendation-direction.md)
* [Recommendation Review Status Code System](CodeSystem-cs-recommendation-review-status.md)
* [Recommendation Strength (AWMF)](CodeSystem-cs-recommendation-strength-awmf.md)
* [Recommendation Synthesis Type](CodeSystem-cs-recommendation-synthesis-type.md)
* [Recommendation Tags](CodeSystem-cs-recommendation-tags.md)
* [Related Artifact Types](CodeSystem-cs-related-artifact-types.md)
* [Remark Type](CodeSystem-cs-remark-type.md)
* [RoB2 Overall Judgment](CodeSystem-cs-rob-2-overall-judgment.md)
* [ROBIS Judgment of Risk of Bias](CodeSystem-cs-robis-judgment-of-risk-of-bias.md)
* [ROBIS Risk of Bias Domains](CodeSystem-cs-robis-risk-of-bias-domains.md)
* [SIGN Grade of Recommendation](CodeSystem-cs-sign-grade-of-recommendation.md)
* [SIGN Level of Evidence](CodeSystem-cs-sign-level-of-evidence.md)
* [Target Patient Group](CodeSystem-cs-target-patient-group.md)

### ValueSets

* [OCEBM 2011 Levels of Evidence Value Set](ValueSet-ocebm-2011-levels-of-evidence-vs.md)
* [AGREE II Domains Value Set](ValueSet-vs-agree-ii-domains.md)
* [AMSTAR 2 Confidence Ratings Value Set](ValueSet-vs-amstar2-confidence-ratings.md)
* [AWMF Guideline Class](ValueSet-vs-awmf-guideline-class.md)
* [AWMF Guideline Status](ValueSet-vs-awmf-guideline-status.md)
* [Body System Conditions](ValueSet-vs-body-system-conditions.md)
* [Care Level](ValueSet-vs-care-level.md)
* [Care Stage](ValueSet-vs-care-stage.md)
* [Clinical Application Type](ValueSet-vs-clinical-application-type.md)
* [Content Types](ValueSet-vs-content-types.md)
* [Dissemination Website](ValueSet-vs-dissemination-website.md)
* [Encounter Type](ValueSet-vs-encounter-type.md)
* [Guideline Author Role](ValueSet-vs-guideline-author-role.md)
* [Guideline Contact Point VS](ValueSet-vs-guideline-contact-point.md)
* [Guideline Release Type](ValueSet-vs-guideline-release-type.md)
* [Guideline Sections](ValueSet-vs-guideline-sections.md)
* [Intended Audience Value Set](ValueSet-vs-intended-audience.md)
* [Level Of Consensus](ValueSet-vs-level-of-consensus.md)
* [Medical Subject Categories](ValueSet-vs-medical-subject-categories.md)
* [OCEBM 2009 Levels of Evidence Value Set](ValueSet-vs-ocebm-2009-levels-of-evidence.md)
* [PICO related terms](ValueSet-vs-pico.md)
* [Rating Acceptability](ValueSet-vs-rating-acceptability.md)
* [Rating Benefits And Harms](ValueSet-vs-rating-benefits-and-harms.md)
* [Rating Certainty Of Evidence](ValueSet-vs-rating-certainty-of-evidence.md)
* [Rating Concern Degree](ValueSet-vs-rating-concern-degree.md)
* [Rating Equity](ValueSet-vs-rating-equity.md)
* [Rating Feasibility](ValueSet-vs-rating-feasibility.md)
* [Rating Preference And Values](ValueSet-vs-rating-preference-and-values.md)
* [Rating Resources](ValueSet-vs-rating-resources.md)
* [Recommendation Direction](ValueSet-vs-recommendation-direction.md)
* [Recommendation Review Status Value Set](ValueSet-vs-recommendation-review-status.md)
* [Recommendation Strength (AWMF) ValueSet](ValueSet-vs-recommendation-strength-awmf.md)
* [Recommendation Synthesis Type](ValueSet-vs-recommendation-synthesis-type.md)
* [Recommendation Tags](ValueSet-vs-recommendation-tags.md)
* [Remark Type](ValueSet-vs-remark-type.md)
* [RoB2 Overall Judgment ValueSet](ValueSet-vs-rob-2-overall-judgment.md)
* [ROBIS Judgment of Risk of Bias Value Set](ValueSet-vs-robis-judgment-of-risk-of-bias.md)
* [ROBIS Risk of Bias Domains Value Set](ValueSet-vs-robis-risk-of-bias-domains.md)
* [SIGN Grade of Recommendation Value Set](ValueSet-vs-sign-grade-of-recommendation.md)
* [SIGN Level of Evidence Value Set](ValueSet-vs-sign-level-of-evidence.md)
* [Target Patient Group](ValueSet-vs-target-patient-group.md)

### Resource Profiles

* [AWMF S1 Guideline Registry Record](StructureDefinition-awmf-guideline-record-s1.md)
* [AWMF S2e Guideline Registry Record](StructureDefinition-awmf-guideline-record-s2e.md)
* [AWMF S2k Guideline Registry Record](StructureDefinition-awmf-guideline-record-s2k.md)
* [AWMF S3 Guideline Registry Record](StructureDefinition-awmf-guideline-record-s3.md)
* [Guideline](StructureDefinition-awmf-guideline.md)
* [AWMF Member Organization](StructureDefinition-awmf-member-organization.md)
* [Citation List](StructureDefinition-citation-list.md)
* [Conceptual Cohort Definition Comparator](StructureDefinition-conceptual-cohort-definition-comparator.md)
* [Conceptual Cohort Definition Intervention](StructureDefinition-conceptual-cohort-definition-intervention.md)
* [Conceptual Cohort Definition Outcome](StructureDefinition-conceptual-cohort-definition-outcome.md)
* [Conceptual Cohort Definition Population](StructureDefinition-conceptual-cohort-definition-population.md)
* [Evidence Assessment](StructureDefinition-evidence-assessment.md)
* [Evidence Internal Assessment AGREE II](StructureDefinition-evidence-internal-assessment-agreeii.md)
* [Evidence Internal Assessment AMSTAR 2](StructureDefinition-evidence-internal-assessment-amstar2.md)
* [Evidence Internal Assessment Cochrane Risk of Bias](StructureDefinition-evidence-internal-assessment-cochrane-rob.md)
* [Evidence Internal Assessment ROBIS](StructureDefinition-evidence-internal-assessment-robis.md)
* [Evidence Internal Validity Assessment](StructureDefinition-evidence-internal-validity-assessment.md)
* [Evidence Overall Assessment GRADE](StructureDefinition-evidence-overall-assessment-grade.md)
* [Evidence Overall Assessment Oxford 2011](StructureDefinition-evidence-overall-assessment-oxford2011.md)
* [Evidence Overall Quality Assessment](StructureDefinition-evidence-overall-quality-assessment.md)
* [Evidence Report with Contact Slices](StructureDefinition-evidence-report-with-contact-slices.md)
* [Guideline Attachment](StructureDefinition-guideline-attachment.md)
* [Guideline Author Role](StructureDefinition-guideline-author-role.md)
* [Guideline Author](StructureDefinition-guideline-author.md)
* [Guideline Registry Record](StructureDefinition-guideline-registry-record.md)
* [Medical Society](StructureDefinition-medical-society.md)
* [Outcome Evidence](StructureDefinition-outcome-evidence.md)
* [Patient Organization](StructureDefinition-patient-organization.md)
* [PICO Question](StructureDefinition-pico-question.md)
* [Recommendation Justification AWMF](StructureDefinition-recommendation-justification-awmf.md)
* [Recommendation Justification Expert Consensus](StructureDefinition-recommendation-justification-expert-consensus.md)
* [Recommendation Justification GRADE](StructureDefinition-recommendation-justification-grade.md)
* [Recommendation Justification OXFORD 2009](StructureDefinition-recommendation-justification-oxford-2009.md)
* [Recommendation Justification OXFORD 2011](StructureDefinition-recommendation-justification-oxford-2011.md)
* [Recommendation Justification SIGN](StructureDefinition-recommendation-justification-sign.md)
* [Recommendation Justification](StructureDefinition-recommendation-justification.md)
* [Recommendation](StructureDefinition-recommendation.md)

### Extensions

* [Artifact Contact (Extended)](StructureDefinition-ext-artifact-extended-contact.md)
* [Author Language](StructureDefinition-ext-author-language.md)
* [Consultation Period](StructureDefinition-ext-consultation-period.md)
* [First Publication Date](StructureDefinition-ext-first-publication-date.md)
* [Guideline Author Role](StructureDefinition-ext-guideline-author-role.md)
* [Medical Subject Category](StructureDefinition-ext-medical-subject-category.md)
* [Medical Subject](StructureDefinition-ext-medical-subject.md)
* [Planned Completion Date](StructureDefinition-ext-planned-completion-date.md)
* [Publication Date](StructureDefinition-ext-publication-date.md)
* [Recommendation Review Status](StructureDefinition-ext-recommendation-review-status.md)
* [Registration Date](StructureDefinition-ext-registration-date.md)
* [RelatesTo Classifier](StructureDefinition-ext-relates-to-classifier.md)
* [RelatesTo Label](StructureDefinition-ext-relates-to-label.md)
* [Section Coding](StructureDefinition-ext-section-coding.md)
* [Section Intended Audience](StructureDefinition-ext-section-intended-audience.md)
* [Section Keyword](StructureDefinition-ext-section-keyword.md)
* [Section Language](StructureDefinition-ext-section-language.md)
* [Submission Date](StructureDefinition-ext-submission-date.md)

### ImplementationGuides

* [Dissolve-E: AWMF Guideline Registry](index.md)

### Examples

* [RecommendationCognitiveTestsWhenSuspectingDementia-Justification (ArtifactAssessment)](ArtifactAssessment-RecommendationCognitiveTestsWhenSuspectingDementia-Justification.md)
* [EvA-MultiplexPCRDiagnostic-AntibioticDays (ArtifactAssessment)](ArtifactAssessment-EvA-MultiplexPCRDiagnostic-AntibioticDays.md)
* [EvA-MultiplexPCRDiagnostic-Mortality (ArtifactAssessment)](ArtifactAssessment-EvA-MultiplexPCRDiagnostic-Mortality.md)
* [EvA-MultiplexPCRDiagnostic-TimeToDeescalation (ArtifactAssessment)](ArtifactAssessment-EvA-MultiplexPCRDiagnostic-TimeToDeescalation.md)
* [RecommendationHAPDiagnosis-A-Justification (ArtifactAssessment)](ArtifactAssessment-RecommendationHAPDiagnosis-A-Justification.md)
* [RecommendationHAPDiagnosis-B-Justification (ArtifactAssessment)](ArtifactAssessment-RecommendationHAPDiagnosis-B-Justification.md)
* [RecommendationMultiplexPCRDiagnostic-Justification (ArtifactAssessment)](ArtifactAssessment-RecommendationMultiplexPCRDiagnostic-Justification.md)
* [RoB-CognitiveTestsWhenSuspectingDementia-Sensitivity (ArtifactAssessment)](ArtifactAssessment-RoB-CognitiveTestsWhenSuspectingDementia-Sensitivity.md)
* [RoB-CognitiveTestsWhenSuspectingDementia-Specificity (ArtifactAssessment)](ArtifactAssessment-RoB-CognitiveTestsWhenSuspectingDementia-Specificity.md)
* [Cognitive Tests to Detect Dementia: A Systematic Review and Meta-analysis. (Citation)](Citation-CitationSystematicReviewTsoi2015.md)
* [AWMF S2k Example Guideline (Composition)](Composition-AWMFGuidelineRecordS2kExample.md)
* [AWMF S3 Example Guideline (Composition)](Composition-AWMFGuidelineRecordS3Example.md)
* [AWMF S1 Example Guideline (Composition)](Composition-AWMFGuidelineS1Example.md)
* [AWMF S2e Example Guideline (Composition)](Composition-AWMFGuidelineS2eExample.md)
* [Demenzen (Composition)](Composition-Demenzen.md)
* [Demenzen (Composition)](Composition-DemenzenRecord.md)
* [Example Guideline (Composition)](Composition-G-TestTestInvRequireOfficialIdentifier-NoOfficialId-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-G-TestTestInvRequireOfficialIdentifier-TwoOfficialId-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-G-TestTestInvVersionMajorMinor-VersionInvalid-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-G-TestTestInvVersionMajorMinor-VersionInvalid2-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-G-TestTestInvVersionMajorMinor-VersionPatch-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-GuidelineExample.md)
* [Example Guideline (Composition)](Composition-GuidelineRegistryRecordExample.md)
* [Epidemiologie, Diagnostik und Therapie erwachsener Patienten mit nosokomialer Pneumonie (Composition)](Composition-NosokomialePneumonie.md)
* [Epidemiologie, Diagnostik und Therapie erwachsener Patienten mit nosokomialer Pneumonie (Composition)](Composition-NosokomialePneumonieRecord.md)
* [Contributing Author Practitioner Fail (Composition)](Composition-RR-TestInvContribAuthorRefPerson-SHOULD-FAIL.md)
* [Leading Author Organization Pass (Composition)](Composition-RR-TestInvLeadingAuthorRefOrganization-SHOULD-PASS.md)
* [Leading Author Practitioner Fail (Composition)](Composition-RR-TestInvLeadingAuthorRefPerson-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvAuthorLeadVsContrExclusive-Both-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvAuthorRegistSingleton-NoRegistrant-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvAuthorRegistSingleton-TwoRegistrants-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvAuthorRegistrantSingleton-SHOULD-PASS.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvPrelimCompNeedsConsultPeriod-NoDate-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvPreliminaryCompNeedsConsultPeriod-SHOULD-PASS.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvRegCompNeedsPlannedComplDate-NoDate-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvRegCompNeedsPlannedComplDate-SHOULD-PASS.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvRequireOfficialId-NoOfficialId-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvRequireOfficialId-TwoOfficialId-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvRequireReleaseTypeIfReg-WrongCode-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvRequireReleaseTypeIfRegistered-NoTag-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvRequireReleaseTypeIfRegistered-SHOULD-PASS.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvVersionMajorMinor-VersionInvalid-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvVersionMajorMinor-VersionInvalid2-SHOULD-FAIL.md)
* [Example Guideline (Composition)](Composition-RR-TestTestInvVersionMajorMinor-VersionPatch-SHOULD-FAIL.md)
* [Screening auf kognitive Beeinträchtigung (Composition)](Composition-RecommendationCognitiveTestsWhenSuspectingDementia.md)
* [Example Recommendation (Composition)](Composition-RecommendationExample.md)
* [HAP Diagnose (Composition)](Composition-RecommendationHAPDiagnosis-A.md)
* [HAP Diagnose (Composition)](Composition-RecommendationHAPDiagnosis-B.md)
* [HAP Diagnose (Composition)](Composition-RecommendationHAPDiagnosis.md)
* [Multiplex-PCR-Diagnostik (Composition)](Composition-RecommendationMultiplexPCRDiagnostic.md)
* [Concept map from FHIR Composition Status to AWMF Guideline Status (ConceptMap)](ConceptMap-FHIRStatusToAWMFStatus.md)
* [Guideline-020-013-GuidelineReport (DocumentReference)](DocumentReference-Guideline-020-013-GuidelineReport.md)
* [Guideline-020-013-ImplementationGuidance (DocumentReference)](DocumentReference-Guideline-020-013-ImplementationGuidance.md)
* [Guideline-020-013-LongVersion (DocumentReference)](DocumentReference-Guideline-020-013-LongVersion.md)
* [Guideline-020-013-PatientVersion (DocumentReference)](DocumentReference-Guideline-020-013-PatientVersion.md)
* [Guideline-020-013-ShortVersion (DocumentReference)](DocumentReference-Guideline-020-013-ShortVersion.md)
* [Guideline-020-013-SlideDeck (DocumentReference)](DocumentReference-Guideline-020-013-SlideDeck.md)
* [guideline-attachment-example (DocumentReference)](DocumentReference-guideline-attachment-example.md)
* [guideline-attachment-patient-version-example (DocumentReference)](DocumentReference-guideline-attachment-patient-version-example.md)
* [Evidence-MultiplexPCRDiagnostic-AntibioticDays (Evidence)](Evidence-Evidence-MultiplexPCRDiagnostic-AntibioticDays.md)
* [Evidence-MultiplexPCRDiagnostic-Mortality (Evidence)](Evidence-Evidence-MultiplexPCRDiagnostic-Mortality.md)
* [Evidence-MultiplexPCRDiagnostic-TimeToDeescalation (Evidence)](Evidence-Evidence-MultiplexPCRDiagnostic-TimeToDeescalation.md)
* [OutcomeAntibioticDays (EvidenceVariable)](EvidenceVariable-OutcomeAntibioticDays.md)
* [OutcomeMortality (EvidenceVariable)](EvidenceVariable-OutcomeMortality.md)
* [OutcomeTimeToDeescalation (EvidenceVariable)](EvidenceVariable-OutcomeTimeToDeescalation.md)
* [PICOComparatorRec17 (Group)](Group-PICOComparatorRec17.md)
* [PICOInterventionRec17 (Group)](Group-PICOInterventionRec17.md)
* [PICOOutcomeSensitivityRec17 (Group)](Group-PICOOutcomeSensitivityRec17.md)
* [PICOOutcomeSpecificityRec17 (Group)](Group-PICOOutcomeSpecificityRec17.md)
* [PICOPopulationRec17 (Group)](Group-PICOPopulationRec17.md)
* [PICOQuestionRec17 (Group)](Group-PICOQuestionRec17.md)
* [Arbeitsgemeinschaft der Wissenschaftlichen Medizinischen Fachgesellschaften (AWMF) (Organization)](Organization-AWMF.md)
* [Example AWMF Member Organization (Organization)](Organization-AWMFMemberOrganizationExample.md)
* [Netzwerk chronisch pulmonale Aspergillose (CPAnet) (Organization)](Organization-CPAnet.md)
* [Deutsche Gesellschaft für Anästhesiologie und Intensivmedizin e.V. (DGAI) (Organization)](Organization-DGAI.md)
* [Deutsche Gesellschaft für Chirurgie e.V. (DGCH) (Organization)](Organization-DGCH.md)
* [Deutsche Gesellschaft für Hygiene und Mikrobiologie e.V. (DGHM) (Organization)](Organization-DGHM.md)
* [Deutsche Gesellschaft für Infektiologie e.V. (DGI) (Organization)](Organization-DGI.md)
* [Deutsche Gesellschaft für Internistische Intensivmedizin und Notfallmedizin e.V. (DGIIN) (Organization)](Organization-DGIIN.md)
* [Deutsche Gesellschaft für Innere Medizin e.V. (DGIM) (Organization)](Organization-DGIM.md)
* [Deutsche Gesellschaft für Pneumologie und Beatmungsmedizin e.V. (DGP) (Organization)](Organization-DGP.md)
* [Deutsche Gesellschaft für Psychiatrie und Psychotherapie, Psychosomatik und Nervenheilkunde e. V. (DGPPN) (Organization)](Organization-DGPPN.md)
* [Deutsche Röntgengesellschaft, Gesellschaft für Medizinische Radiologie e.V. (DRG) (Organization)](Organization-DRG.md)
* [Deutsche Sepsis-Gesellschaft e.V. (DSG) (Organization)](Organization-DSG.md)
* [Gesellschaft für Virologie e.V. (GfV) (Organization)](Organization-GFV.md)
* [Example Medical Society (Organization)](Organization-MedicalSocietyExample.md)
* [Paul-Ehrlich-Gesellschaft für Infektionstherapie e.V. (PEG) (Organization)](Organization-PEG.md)
* [Robert Koch-Institut (RKI) (Organization)](Organization-RKI.md)
* [Recommendation-PlanDefinition-example (PlanDefinition)](PlanDefinition-Recommendation-PlanDefinition-example.md)
* [GuidelineAuthorExample (Practitioner)](Practitioner-GuidelineAuthorExample.md)
* [JessicaRademacher (Practitioner)](Practitioner-JessicaRademacher.md)
* [contributor0 (Practitioner)](Practitioner-contributor0.md)
* [contributor1 (Practitioner)](Practitioner-contributor1.md)
* [contributor2 (Practitioner)](Practitioner-contributor2.md)
* [contributor3 (Practitioner)](Practitioner-contributor3.md)
* [contributor4 (Practitioner)](Practitioner-contributor4.md)
* [GuidelineAuthorRoleExample (PractitionerRole)](PractitionerRole-GuidelineAuthorRoleExample.md)
* [JessicaRademacherDGPFor020-013 (PractitionerRole)](PractitionerRole-JessicaRademacherDGPFor020-013.md)
