# Profiles - Dissolve-E: AWMF Guideline Registry v0.2.0

* [**Table of Contents**](toc.md)
* **Profiles**

## Profiles

### Profiles

#### Profiles related to Guidelines

[Guideline](StructureDefinition-awmf-guideline.md)

Clinical Practice Guideline

[Guideline Attachment](StructureDefinition-guideline-attachment.md)

Attachment to a Clinical Practice Guideline

[Guideline Registry Record](StructureDefinition-guideline-registry-record.md)

Guideline Registry Record containing metadata and registry-specific information for a clinical practice guideline.

[AWMF S1 Guideline Registry Record](StructureDefinition-awmf-guideline-record-s1.md)

AWMF S1 guideline representing expert recommendations developed through informal consensus.

[AWMF S2e Guideline Registry Record](StructureDefinition-awmf-guideline-record-s2e.md)

AWMF S2e guideline based on systematic literature search and evaluation.

[AWMF S2k Guideline Registry Record](StructureDefinition-awmf-guideline-record-s2k.md)

AWMF S2k guideline based on structured consensus by a representative panel.

[AWMF S3 Guideline Registry Record](StructureDefinition-awmf-guideline-record-s3.md)

AWMF S3 guideline based on systematic evidence review and structured consensus by a representative panel.

[Guideline Author](StructureDefinition-guideline-author.md)

A person that authored a guideline.

[Guideline Author Role](StructureDefinition-guideline-author-role.md)

The role of the author of the guideline.

[Guideline Author Role](StructureDefinition-ext-guideline-author-role.md)

This extension allows for the indication of the role of the author of the guideline.

#### Profiles related to Recommendations

[Recommendation](StructureDefinition-recommendation.md)

Clinical Practice Guideline Recommendation

#### Profiles related to Recommendation Justifications

[Recommendation Justification](StructureDefinition-recommendation-justification.md)

A structured assessment of the evidence and consensus that underpins a recommendation.

[Recommendation Justification AWMF](StructureDefinition-recommendation-justification-awmf.md)

A structured assessment of the evidence and consensus that underpins a recommendation, including AWMF rating.

[Recommendation Justification Expert Consensus](StructureDefinition-recommendation-justification-expert-consensus.md)

A structured assessment of the evidence and consensus that underpins a recommendation based on expert consensus.

[Recommendation Justification GRADE](StructureDefinition-recommendation-justification-grade.md)

A structured assessment of the evidence and consensus that underpins a recommendation using the GRADE evidence rating system.

[Recommendation Justification OXFORD 2009](StructureDefinition-recommendation-justification-oxford-2009.md)

A structured assessment of the evidence and consensus that underpins a recommendation using the OXFORD 2009 evidence rating system.

[Recommendation Justification OXFORD 2011](StructureDefinition-recommendation-justification-oxford-2011.md)

A structured assessment of the evidence and consensus that underpins a recommendation using the OXFORD 2011 evidence rating system.

[Recommendation Justification SIGN](StructureDefinition-recommendation-justification-sign.md)

A structured assessment of the evidence and consensus that underpins a recommendation using the SIGN evidence rating system.

#### Profiles related to Evidence Assessment

##### Overall Evidence Assessment

[Evidence Overall Quality Assessment](StructureDefinition-evidence-overall-quality-assessment.md)

A structured assessment of the overall evidence for a specific outcome.

[Evidence Overall Assessment GRADE](StructureDefinition-evidence-overall-assessment-grade.md)

A structured assessment of the certainty of evidence for a specific outcome, including GRADE rating.

[Evidence Overall Assessment Oxford 2011](StructureDefinition-evidence-overall-assessment-oxford2011.md)

A structured assessment of the certainty of evidence for a specific outcome, including Oxford 2011 rating.

##### Internal Validity Assessment

[Evidence Internal Validity Assessment](StructureDefinition-evidence-internal-validity-assessment.md)

A structured assessment of the internal validity of evidence.

[Evidence Internal Assessment AGREE II](StructureDefinition-evidence-internal-assessment-agreeii.md)

A structured assessment of the quality of guidelines using the AGREE II instrument.

[Evidence Internal Assessment AMSTAR 2](StructureDefinition-evidence-internal-assessment-amstar2.md)

A structured assessment of the certainty of evidence using AMSTAR 2.

[Evidence Internal Assessment Cochrane Risk of Bias](StructureDefinition-evidence-internal-assessment-cochrane-rob.md)

Structured assessment of risk of bias using Cochrane RoB tool.

[Evidence Internal Assessment ROBIS](StructureDefinition-evidence-internal-assessment-robis.md)

Structured assessment of risk of bias using ROBIS (Risk of Bias in Systematic Reviews).

[Evidence Internal Validity Assessment](StructureDefinition-evidence-internal-validity-assessment.md)

A structured assessment of the internal validity of evidence.

[Evidence Overall Quality Assessment](StructureDefinition-evidence-overall-quality-assessment.md)

A structured assessment of the overall evidence for a specific outcome.

#### Profiles related to PICO Questions

[PICO Question](StructureDefinition-pico-question.md)

A structured definition of the PICO question in the context of guidelines and recommendations.

[Conceptual Cohort Definition Comparator](StructureDefinition-conceptual-cohort-definition-comparator.md)

A structured definition of the comparator as defined for a PICO question.

[Conceptual Cohort Definition Intervention](StructureDefinition-conceptual-cohort-definition-intervention.md)

A structured definition of the intervention as defined for a PICO question.

[Conceptual Cohort Definition Outcome](StructureDefinition-conceptual-cohort-definition-outcome.md)

A structured definition of the outcome as defined for a PICO question.

[Conceptual Cohort Definition Population](StructureDefinition-conceptual-cohort-definition-population.md)

A structured definition of the population as defined for a PICO question.

#### Profiles related to Organizations

[AWMF Member Organization](StructureDefinition-awmf-member-organization.md)

An organization that is a member of the AWMF

[Medical Society](StructureDefinition-medical-society.md)

A profile for medical societies.

[Patient Organization](StructureDefinition-patient-organization.md)

An organization that represents patients

#### Other

[Outcome Evidence](StructureDefinition-outcome-evidence.md)

Represents evidence supporting a specific outcome within a body of clinical or scientific evidence.

[Citation List](StructureDefinition-citation-list.md)

List of citations.

